;ͻ
;                                                                          
;                     Copyright (c) 1996 Aldo Ferraro                      
;                           All Rights Reserved                            
;                                                                          
;Ķ
;                                                                          
;  Source File :  FMODE.ASM                                                
;                                                                          
;  Procedures  :  1. real_flat_mode  -  set 4 Gb RAM limit in real mode    
;                 2. get_A20_status  -  get current A20 status             
;                 3. set_A20_status  -  enable/disable A20 Address Line    
;                 4. get_xmem_size   -  get size of extended memory        
;                                                                          
;  Description :  As specifically described for each procedure - see code. 
;                                                                          
;  Compiler    :  TASM version 3.1                                         
;                                                                          
;  Compilation :  FMODE.ASM, MODEL.INC                                     
;                                                                          
;  Author Name :  Aldo Ferraro                                             
;                                                                          
;  Address     :  19 Munro Close, Swindon, Wiltshire, England SN3 1BF      
;                                                                          
;  Developed on:  15 June 1996 - version 1.00.                             
;                                                                          
;  Last Update :  23 July 1996 - version 1.01.                             
;                                                                          
;ͼ

;ͻ
;                              Include Files                               
;ͼ

	INCLUDE	MODEL.INC

;ͻ
;                        Declare Public Procedures                         
;ͼ

	PUBLIC	_real_flat_mode, _get_A20_status, _get_xmem_size

;ͻ
;                                Data Segment                              
;ͼ

	.DATA

gdt	dw	0FFFFh                  ; 00 - null selector descriptor
	dw	3 dup (0)

gig_dsc dw	0FFFFh			; 08 - 4 Gb data segment descriptor
	dw      0
	db	0
	db	92h
	db	0CFh
	db	0FFh

;ͻ
;                               Code Segment                               
;ͼ

	.CODE

;ͻ
;                              Real Flat Mode                              
;Ķ
;                                                                          
;  Procedure   :  Real Flat Mode enables access to the full 4 gigabytes of 
;                 memory as far as data is concerned.  The code must still 
;                 reside within the 1 Meg of RAM, but this should not be a 
;                 problem as it is the data and not the code which usually 
;                 requires that extra RAM.  However, it must be emphasised 
;                 that any application incorporating this procedure cannot 
;                 coexist with protected mode systems as Microsoft Windows 
;                 or simple protected mode memory managers as EMM386.SYS.  
;                                                                          
;  Requirement :  80386 CPU or higher.                                     
;                                                                          
;  Prototype   :  int real_flat_mode(void)                                 
;                                                                          
;  Entry       :  void                                                     
;                                                                          
;  Return      :  1  =  Real Flat Mode Enabled                             
;                 0  =  already in Protected Mode                          
;                                                                          
;ͼ

_real_flat_mode	proc

	push  	bp
	mov   	bp,sp

;Ŀ
; Test Protection Enable (PE) bit of Machine Status Word (MSW) register to 
; ensure CPU not already in protected mode. Although the MSW register only 
; plays a role in protected mode, the  flag  register will always indicate 
; the current state of the CPU.                                            
;

	smsw	ax			; get current machine status word
	test	al,1			; real/protected mode (FFF0/FFF1) ?
	jz	pm_clear		; jump if in real mode
	xor	ax,ax 			; else, set ax to return false
	jmp	pm_exit                 ; bail out

pm_clear:

;Ŀ
; A nested task is used in  protected mode  to supervise  chaining  of the 
; interrupted and deactivated tasks,  and is managed by operating systems. 
; However, if the nested task flag (NT) bit in the flag register is set to 
; 1, a task switch has occurred;  indicating either a former task is still 
; executing, or a new task is ready for execution.  Hence,  the first IRET 
; instruction executed will result in reversing the operation of the  CALL 
; or INT instruction that caused it. To avoid possible problems occurring, 
; the following code resets the NT bit in the flag register to zero.       
;

	pushf
	pop	ax
	and	ax,3FFFh
	push	ax
	popf

;Ŀ
;                                 Load GDT                                 
;

	mov 	eax,seg gdt
	shl 	eax,4                   ; shift left one nibble
	mov 	bx,offset gdt
	movzx 	ebx,bx
	add 	eax,ebx
	mov 	dword ptr gdt+2,eax
	lgdt 	fword ptr gdt        	; load GDT

;Ŀ
;                        Enable A20 Gate if Disabled                       
;

	call	cs:_get_A20_status	; get current A20 status
	test	ax,1			; is A20 gate enabled ?
	jnz	A20_set			; jump if A20 enabled
	mov	ah,0DFh			; enable A20 address line
	call	cs:_set_A20_status
	test	ax,1			; is A20 gate enabled ?
	jnz	A20_set			; jump if A20 enabled
	xor	ax,ax 			; else, set ax to return false
	jmp	pm_exit                 ; bail out

A20_set:

;Ŀ
;                         Switch to protected mode                         
;

	mov 	bx,offset gig_dsc - offset gdt
	push 	ds
	mov 	eax,cr0                 ; get current cr0
	or 	al,1                    ; set PM bit
	cli
	mov 	cr0,eax			; switch to protected mode
	jmp 	$+2                     ; flush prefetch queue

;Ŀ
;  Set ds, es, fs and gs segment limit (4 gigabytes) and granularity bits  
;

	mov 	ds,bx
	mov 	es,bx
	mov 	fs,bx
	mov 	gs,bx

;Ŀ
;             Swith back to real mode without resetting CPU                
;

	and 	al,0FEh			; turn off PM bit
	mov 	cr0,eax			; return to real mode
	jmp 	$+2                     ; flush prefetch queue
	sti
	pop 	ds
	mov	ax,1			; set ax to return true

pm_exit:
	pop	bp
	ret

_real_flat_mode	endp

;ͻ
;                             Get A20 Status                               
;Ķ
;                                                                          
;  Procedure   :  The 80286 and later processors have an A20 address line  
;                 that enables the  CPU  to address memory from 0FFFF:10h  
;                 through to 0FFFF:FFFFh,  and can actually access memory  
;                 up to 64Kb - 16 bytes above the 1 Mb boundary. However,  
;                 if the A20 line is disabled,  the CPU emulates an 8088.  
;                 Hence, if an attempt is made to address memory location  
;                 0FFFF:50 with the A20 line disabled, you would actually  
;                 access the memory location 0:40h because of the address  
;                 wrap-around.                                             
;                                                                          
;                 To determine the state of A20 gate, the procedure first  
;                 inverts the word at address 0:0,  and compares the word  
;                 with the data located at address FFFF:10. If identical,  
;                 the A20 is assumed to be disabled.                       
;                                                                          
;  Entry       :  int get_A20_status(void)                                 
;                                                                          
;  Return      :  ax  =  0, A20 disabled                                   
;                     =  1, A20 enabled                                    
;                                                                          
;ͼ

_get_A20_status		proc

	push	di
	push	si
	push	ds
	push	es
	cli
	mov	ax,0FFFFh               ; es:di -> FFFF:10h
	mov	es,ax
	mov	di,10h
	xor	ax,ax			; ds:si -> 0:0
	mov	si,ax
	mov	ds,ax
	not	word ptr ds:[si]	; invert word
	cld
	cmpsw				; compare ds:[si] with es:[di]
	je	got_A20			; jump if A20 disabled
	mov	ax,1			; A20 enabled, return true

got_A20:
	not	word ptr ds:[si]	; restore original word
	sti
	pop	es
	pop	ds
	pop	si
	pop	di
	ret

_get_A20_status		endp

;ͻ
;                             Set A20 Status                               
;Ķ
;                                                                          
;  Procedure   : Enable/Disable the A20 Address Line.                      
;                                                                          
;                The output port of the keyboard controller can lock  the  
;                A20 address line of the  80286  and higher CPU's via the  
;                GA20 bit to emulate the 8086/88 address wrap-around.  At  
;                start-up, the A20 Gate is disabled by default.  However,  
;                this may not always be the case,  and you should confirm  
;                the A20 status with a call to get_A20_status.             
;                                                                          
;  Note        : To access the 64K - 16 bytes above the 1Mb boundary, you  
;                must enable the A20 address line.                         
;                                                                          
;  Entry       :  ah  =  0DFh  to Enable the A20 Address Line              
;                     =  0DDh  to Disable the A20 Address Line             
;                                                                          
;  Return      :  ax  =  0, A20 disabled                                   
;                     =  1, A20 enabled                                    
;                                                                          
;ͼ

_set_A20_status		proc

	push	cx
	cli
	xor	cx,cx			; set timeout counter

A20_1:
	in	al,64h                  ; read 8042 status register
	test	al,2                    ; check if input buffer full
	loopnz	A20_1                   ; wait until not busy or timeout
	mov	al,0D1h			; 8042 command for write output port
	out	64h,al
	xor	cx,cx			; set timeout counter

A20_2:
	in	al,64h                  ; read 8042 status register
	test	al,2                    ; check if input buffer full
	loopnz	A20_2                   ; wait until not busy or timeout
	mov	al,ah			; enable/disable A20
	out	60h,al
	xor	cx,cx			; set timeout counter

A20_3:
	in	al,64h                  ; read 8042 status register
	test	al,2                    ; check if input buffer full
	loopnz	A20_3                   ; wait until not busy or timeout
	sti
	call	cs:_get_A20_status	; get current A20 status
	pop	cx
	ret

_set_A20_status		endp

;ͻ
;                        Get Extended Memory Size                          
;Ķ
;                                                                          
;  Procedure   :  Get Extended Memory Size.                                
;                                                                          
;  Note        :  If a memory manager as HIMEM.SYS is installed, available 
;                 extended memory may return zero.                         
;                                                                          
;  Entry       :  void                                                     
;                                                                          
;  Return      :  ax  =  size of 1Kb blocks of RAM above 100000h           
;                                                                          
;ͼ

_get_xmem_size  	proc

	mov   	ah,88h
	int     15h
	ret

_get_xmem_size  	endp

;ͻ
;                            End of Assembly                               
;ͼ

	END
